<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Profile</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css"> -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.1.6/dist/sweetalert2.min.css">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- for icon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <!-- Buttons CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <!-- Bootstrap popup-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/css/flatpickr.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedcolumns/3.3.0/css/fixedColumns.dataTables.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">

    <style type="text/css">
        .navbar {
            background: #13265C;
        }

        .nav-link:hover {
            color: #9ffb00 !important;
        }

        .dropdown-menu.left {
            left: auto;
            right: 0;
        }

        .active {

            border-radius: 10px;
            color: #fff;
            font-weight: 500;
            border: 2px solid white;

        }

        body {
            /* padding-top: 50px;  */
            color: #1a202c;
            text-align: left;
            background-color: #e2e8f0;
        }

        .main-body {
            padding: 15px;
        }

        .card {
            box-shadow: 0 1px 3px 0 rgba(0, 0, 0, .1), 0 1px 2px 0 rgba(0, 0, 0, .06);
        }

        .card {
            position: relative;
            display: flex;
            flex-direction: column;
            min-width: 0;
            word-wrap: break-word;
            background-color: #fff;
            background-clip: border-box;
            border: 0 solid rgba(0, 0, 0, .125);
            border-radius: .25rem;
        }

        .card-body {
            flex: 1 1 auto;
            min-height: 1px;
            padding: 1rem;
        }

        .gutters-sm {
            margin-right: -8px;
            margin-left: -8px;
        }

        .gutters-sm>.col,
        .gutters-sm>[class*=col-] {
            padding-right: 8px;
            padding-left: 8px;
        }

        .mb-3,
        .my-3 {
            margin-bottom: 1rem !important;
        }

        .bg-gray-300 {
            background-color: #e2e8f0;
        }

        .h-100 {
            height: 100% !important;
        }

        .shadow-none {
            box-shadow: none !important;
        }

        .rounded {
            border-radius: 50%;
            border: 2px solid #ccc;
            cursor: pointer;

        }

        .profile-img {
            text-align: center;
        }

        .profile-img .file {
            position: relative;
            overflow: hidden;
            margin-top: -25%;
            width: 51%;
            border: none;
            border-radius: 0;
            font-size: 15px;
            background: #212529b8;
        }

        .profile-img .file input {
            position: absolute;
            opacity: 0;
            right: 0;
            top: 0;
        }
    </style>

    <style>
        .red-container {
            background-color: #e9eef7;
            /* Light blue background */
            /* border: 2px solid red; */
            /* Red border */
            height: 100px;
            /* margin-bottom: 100px; */
            /* Adjust height to your preference */
            display: flex;
            /* Center content vertically and horizontally if needed */
            justify-content: center;
            align-items: center;
        }

        /* .container {
            margin-bottom: 100px;
        } */
    </style>

    <!-- CARD -->
    <style>
        table {
            border-collapse: separate;
            border-spacing: 0;
            width: 200px;
            /* margin: 20px auto; */
            text-align: center;
            border: 1px solid #000;
            border-radius: 12px;
            overflow: hidden;
            height: 10px !important;
            background: white !important;
        }

        th {
            font-weight: bold;
            padding: 1px;
        }

        td {
            padding: 10px;
            padding-top: 0;
            padding-bottom: 8px;
            position: relative;
        }

        thead {
            background-color: #f4f4f4;
        }

        .row-heading {
            font-weight: bold;
            font-size: 14px;
            padding-top: 0;
            align-items: center;
            text-align: center;
            word-wrap: break-word;
            max-width: 200px;
        }

        .row-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .left {
            text-align: left;
        }

        .right {
            text-align: right;
            font-size: 24px;
            font-weight: bold;
        }

        .target {
            font-weight: bold;
            font-size: 14px;
            color: gray;
        }

        .percentage {
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 14px;
        }

        .percentage.green {
            color: green;
        }

        .percentage.red {
            color: red;
        }

        .arrow {
            font-size: 12px;
        }

        /* Dotted line separator */
        td:after {
            content: "";
            display: block;
            width: 90%;
            border-bottom: 1px dotted black;
        }

        /* Remove last dotted line */
        tr:last-child td:after {
            content: none;
        }

        #yearBtn,
        #monthBtn,
        #weekBtn {
            background: transparent;
            border: none;
            font-weight: 900;
            font-size: 15px;
        }
    </style>

</head>

<body id="body" class="">
    <!-- spinner -->

    <!-- spinner end -->
    @apexchartsScripts
    @extends('LifeAtGainup.Navbar.Other_Chn')
    @section('content')

    <div class="row mt-2">
        <!-- 1st -->
        <div class="col-sm-4 surya">
            <div class="card" style="padding: 10px;">
                <div class="card-body" style="height: 520px;">
                    <div style="display: flex; justify-content: space-between; align-items: center;background-color: #72a3e0; padding: 5px;">

                        <button id="calendarIcon2" style="color: #fff;" class="btn btn-outline-light">
                            <i class="fa fa-calendar"></i>
                        </button>
                        <h4 style="color: #fff; text-align: center;"> Chart</h4>
                        <button id="optionsButton" class="btn optionsButton" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-industry" style="color: #fff;"></i>
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="optionsButton">
                            <li><a class="dropdown-item" href="#">Sales</a></li>
                            <li><a class="dropdown-item" href="#">Deposit</a></li>
                        </ul>
                        <img class="rounded-circle header-profile-user" height="40px" width="40px" src="{{ asset('frontend/img/userimg.png')}}" alt="Header Avatar">

                    </div>
                    <br>
                    {!! $chart->container() !!}
                    {!! $chart->script() !!}
                </div>
            </div>
        </div>

        <!-- 2nd -->
        <div class="col-sm-3" style="height: 400px;">
            <div class="card" style="padding: 10px;">
                <div class="card-body">
                    <div style="display: flex; justify-content: space-between; align-items: center; background-color: #72a3e0; padding: 5px;">
                        <button id="calendarIcon1" style="color: #fff;" class="btn btn-outline-light">
                            <i class="fa fa-calendar"></i>
                        </button>
                        <h4 style="color: #fff; text-align: center;">Cap Plan</h4>
                        <button id="optionsButton" class="btn optionsButton" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-industry" style="color: #fff;"></i>
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="optionsButton">
                            <li><a class="dropdown-item" href="#">Product A</a></li>
                            <li><a class="dropdown-item" href="#">Product B</a></li>
                        </ul>
                        <img class="rounded-circle header-profile-user" height="40px" width="40px" src="{{ asset('frontend/img/userimg.png')}}" alt="Header Avatar">
                    </div>
                    <div style="height: 300px; display: flex; justify-content: center; align-items: center; overflow: hidden;">
                        {!! $HrbarChart->container() !!}
                    </div>
                    {!! $HrbarChart->script() !!}
                </div>
            </div>
        </div>

        <!-- 3rd -->
        <div class="col-sm-3" style="height: 400px;">
            <div class="col-lg-12">
                <div class="card" style="padding: 10px;">
                    <div class="card-body" style="height: 380px;"> <!-- Uniform height -->
                        <div style="display: flex; justify-content: space-between; align-items: center; background-color: #72a3e0; padding: 5px;">
                            <button id="calendarIcon2" style="color: #fff;" class="btn btn-outline-light">
                                <i class="fa fa-calendar"></i>
                            </button>
                            <h4 style="color: #fff; text-align: center;"> Chart</h4>
                            <button id="optionsButton" class="btn optionsButton" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa fa-industry" style="color: #fff;"></i>
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="optionsButton">
                                <li><a class="dropdown-item" href="#">Sales</a></li>
                                <li><a class="dropdown-item" href="#">Deposit</a></li>
                            </ul>
                            <img class="rounded-circle header-profile-user" height="40px" width="40px" src="{{ asset('frontend/img/userimg.png')}}" alt="Header Avatar">
                        </div>
                        <br>
                        <div style="height: 300px;width: 250px; display: flex; justify-content: center; align-items: center; overflow: hidden;">
                            {!! $HrbarChartStatic->container() !!}
                        </div>
                        {!! $HrbarChartStatic->script() !!}
                    </div>
                </div>
            </div>

        </div>

        <div class="col-sm-2">
            <table>
                <thead>
                    <tr>
                        <th title="Year">
                            <button id="yearBtn" class="btn btn-outline-none">
                                Y
                            </button>
                            <select id="year" name="year">
                                <option value="">Select Year</option>
                            </select>
                        </th>

                        <th title="Month">
                            <button id="monthBtn" class="btn btn-outline-none">
                                M
                            </button>
                            <input type="month" id="month" name="month" style="display:none;">
                        </th>
                        <th title="Week">
                            <button id="weekBtn" class="btn btn-outline-none">
                                W
                            </button>
                            <input type="week" id="week" name="week" style="display:none;">
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td colspan="3">
                            <div class="row-heading">Delivery on Time</div>
                            <div class="row-content">
                                <div class="left">
                                    <div class="target">Target</div>
                                    <div class="percentage green">
                                        <span class="arrow">▲</span>
                                        <span>2.4%</span>
                                    </div>
                                </div>
                                <div class="right">
                                    100%
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="3">
                            <div class="row-heading">Unit Wised Capacity</div>
                            <div class="row-content">
                                <div class="left">
                                    <div class="target">Target</div>
                                    <div class="percentage green">
                                        <span class="arrow">▲</span>
                                        <span>3.4%</span>
                                    </div>
                                </div>
                                <div class="right">
                                    200%
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="3">
                            <div class="row-heading">CK on Time</div>
                            <div class="row-content">
                                <div class="left">
                                    <div class="target">Target</div>
                                    <div class="percentage red">
                                        <span class="arrow">▼</span>
                                        <span>1.5%</span>
                                    </div>
                                </div>
                                <div class="right">
                                    300%
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="3">
                            <div class="row-heading">Planning Accuracy</div>
                            <div class="row-content">
                                <div class="left">
                                    <div class="target">Target</div>
                                    <div class="percentage green">
                                        <span class="arrow">▲</span>
                                        <span>3.4%</span>
                                    </div>
                                </div>
                                <div class="right">
                                    400%
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="3">
                            <div class="row-heading">Changeovers</div>
                            <div class="row-content">
                                <div class="left">
                                    <div class="target">Target</div>
                                    <div class="percentage green">
                                        <span class="arrow">▲</span>
                                        <span>3.4%</span>
                                    </div>
                                </div>
                                <div class="right">
                                    500%
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            <!-- 4th -->
            <div class="col-lg-12">
                <div class="container">
                    <div class="card mt-2" style="padding: 10px; float: right; width: 485%; height:135px">
                        <div class="card-body red-container">
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <!-- DataTables JS -->

    <script src="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <!-- chart plugin  -->

    <!-- CALENDAR -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script>
        // Initialize Date Range Picker for the first chart
        $('#calendarIcon1').daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: 'MM/DD/YYYY'
            }
        }, function(start, end, label) {
            console.log('Selected date: ' + start.format('MM/DD/YYYY'));
            // Update the chart based on the selected date
        });

        // Initialize Date Range Picker for the second chart
        $('#calendarIcon2').daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: 'MM/DD/YYYY'
            }
        }, function(start, end, label) {
            console.log('Selected date: ' + start.format('MM/DD/YYYY'));
            // Update the chart based on the selected date
        });
    </script>

    <script>
        var chartOptions = @json(config('apexcharts.options'));
        var chart = new ApexCharts(document.querySelector("#chart"), chartOptions);
        chart.render();
    </script>


    <script>
        window.onload = function() {
            // Populate Year dropdown
            let yearSelect = document.getElementById('year');
            let currentYear = new Date().getFullYear();
            let startYear = 2023;

            for (let year = startYear; year <= currentYear; year++) {
                let option = document.createElement('option');
                option.value = year;
                option.textContent = year;
                yearSelect.appendChild(option);
            }

            // Initially hide the year select dropdown
            yearSelect.style.display = 'none';

            // Show the year dropdown when the year button is clicked
            document.getElementById('yearBtn').addEventListener('click', function() {
                // Toggle visibility of the year select dropdown
                yearSelect.style.display = (yearSelect.style.display === 'none') ? 'block' : 'none';
            });

            // Show the month picker when the month button is clicked
            let monthInput = document.getElementById('month');
            document.getElementById('monthBtn').addEventListener('click', function() {
                // Toggle the visibility of the month input field
                if (monthInput.style.display === 'none') {
                    monthInput.style.display = 'block'; // Show the month input field
                    monthInput.focus(); // Focus the input field
                    monthInput.style.display = 'none'; // Show the month input field
                    monthInput.showPicker(); // Open the month picker
                } else {
                    monthInput.style.display = 'none'; // Hide the month input field
                }
            });

            // Show the week picker when the week button is clicked
            let weekInput = document.getElementById('week');
            document.getElementById('weekBtn').addEventListener('click', function() {
                if (weekInput.style.display === 'none') {
                    weekInput.style.display = 'block'; // Show the month input field
                    weekInput.focus(); // Focus the input field
                    weekInput.style.display = 'none'; // Show the month input field
                    weekInput.showPicker(); // Open the month picker
                } else {
                    weekInput.style.display = 'none'; // Hide the month input field
                }
            });
        };
    </script>

    @endsection
</body>

</html>